define(function (require) {
	'use strict';

	$.bootstrapGrowl.default_options = {
		ele: "body",
		type: "info",
		offset: {
			from: "bottom",
			amount: 20
		},
		align: "right",
		width: 400,
		delay: 4000,
		allow_dismiss: true,
		stackup_spacing: 10
	};

	return {
		msg: function (msg, opt) {
			$.bootstrapGrowl(msg, opt);
		},
		errorMsg: function (msg) {
			this.msg(msg, {type: 'danger'});
		},
		errorMessages: function (messages) {
			var self = this;
			_.each(messages, function (msgs, attribute) {
				_.each(msgs, function (msg) {
					self.errorMsg(msg.message);
				});
			})
		},
		parseResponse: function (jqXHR) {
			var data = $.parseJSON(jqXHR.responseText);

			if (_.isObject(data) && _.isArray(data.errors) && data.errors[0].ValidationError) {
				this.errorMessages(data.errors[0].ValidationError);
			}
		}
	};

});